***************************************************************
*** This do-file creates the tables 4, 5, 6, 7, 8, 9 and 10 ***
***************************************************************

clear
clear matrix
set mem 1g

* !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

* load file
use `njdir'nj_respondents_new.dta, clear

* sample restriction: age 20-65, not working in survey week, did not accept job in survey week or earlier
drop if insample_wrkacc==0
drop if age > 65
drop if age < 20

* generate day of the week dummies (for time use diary)
tab q2, gen(q2_)
drop q2_1

* dummy for post-nov8
gen postnov8 = (stopday>=18210) if stopday!=.

gen vsatisfied = (lifesat==1) if lifesat!=.
gen nsatisfied = (lifesat==4) if lifesat!=.

tab lifesat if lifesat!=., gen(lifesat_)

replace tu_jobsearch= . if curwkwgt_tu==.
replace tw_jobsearch= tw_jobsearch*60/7



*** Table 4: life satifaction ***
tab lifesat [aw=perswgt] if week==1



*** Table 10: life satisfaction by search time ***
gen searchx = 1 if tu_jobsearch==0
replace searchx = 2 if tu_jobsearch>0 & tu_jobsearch<=120
replace searchx = 3 if tu_jobsearch>120 & tu_jobsearch!=.

tabstat lifesat_* [aw=curwkwgt], by(searchx) c(s)

* regressions reported in text 
areg satisfied tu_jobsearch [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
areg satisfied tu_jobsearch tw_jobsearch [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max



*** Table 5: satisfied with life***
eststo table5_1: areg vsatisfied udur_wkpd_wrkacc  [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table5_2: areg vsatisfied udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table5_3: areg satisfied udur_wkpd_wrkacc  [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table5_4: areg satisfied udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table5_5: areg nsatisfied udur_wkpd_wrkacc  [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table5_6: areg nsatisfied udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max




*** Table 6: mood at home ***
forvalues x=1(1)4 {
eststo table6_`x'_1: areg mood_`x' udur_wkpd_wrkacc  [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table6_`x'_2: areg mood_`x' udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
}



*** Table 7-9: emotions ***

* does interview have a valid job search episode in time use diary
gen     isel_mod = 0 if curwkwgt_tu!=. & tu_jobsearch>0
replace isel_mod = 1 if sel_happy!=. & sel_sad!=. & sel_stressed!=. & curwkwgt_tu!=.

* code the job search episode as episode 4 (episode 1-3 are the random episodes)
gen q5_happy_episode4 = sel_happy
gen q5_sad_episode4 = sel_sad
gen q5_stressed_episode4 = sel_stressed
gen q5_randepi_episode4 = .
gen q5_randact_episode4 = .

* create a weight adjustment for the job search episode that adjusts for the lenght of the job search episode
gen wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)

* create an indicator that for whether affect module can be used (all three emotions must be given and and time use diary must be usable)
gen imod_episode1 = 0 if curwkwgt_tu!=.
gen imod_episode2 = 0 if curwkwgt_tu!=.
gen imod_episode3 = 0 if curwkwgt_tu!=.
gen imod_episode4 = 0 if curwkwgt_tu!=.
replace imod_episode1 = 1 if q5_happy_episode1!=. & q5_sad_episode1!=. & q5_stressed_episode1!=. & curwkwgt_tu!=.
replace imod_episode2 = 1 if q5_happy_episode2!=. & q5_sad_episode2!=. & q5_stressed_episode2!=. & curwkwgt_tu!=.
replace imod_episode3 = 1 if q5_happy_episode3!=. & q5_sad_episode3!=. & q5_stressed_episode3!=. & curwkwgt_tu!=.
replace imod_episode4 = 1 if q5_happy_episode4!=. & q5_sad_episode4!=. & q5_stressed_episode4!=. & curwkwgt_tu!=.

* expand data set (individual x week x epsiodes)
gen idd = _n
reshape  long q5_happy_episode q5_sad_episode q5_stressed_episode q5_randepi_episode q5_randact_episode imod_episode, i(idd) j(episode)

* create weight adjustment (an episode weight, depending on probability of being selected)
gen     emwgt = curwkwgt*wgt_js       if episode==4
replace emwgt = curwkwgt*(1-wgt_js)/3 if episode>=1 & episode<=3
gen     emwgt2 = curwkwgt*sel_dur

* activity code of randomly selected episodes
gen q5_randcode=.
gen q5_randcode2=0
forvalues xepi=1(1)16 {
forvalues xact=1(1)2 {
replace q5_randcode = q5_activity`xact'_episode`xepi' if q5_randact_episode==`xact' & q5_randepi_episode==`xepi'
if `xact'==1 {
replace q5_randcode2 = q5_activity2_episode`xepi' if q5_randact_episode==`xact' & q5_randepi_episode==`xepi' & q5_activity2_episode`xepi'!=.
}
if `xact'==2 {
replace q5_randcode2 = q5_activity1_episode`xepi' if q5_randact_episode==`xact' & q5_randepi_episode==`xepi' & q5_activity1_episode`xepi'!=.
}
}
}

replace q5_randcode=7 if episode==4
tab q5_randcode, gen(q5_randcode_)



*** Table 7: emotions, averages and fixed effects ***

*** emotions, averages by activity ***
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt] if imod_episode==1, by(q5_randcode) stats(mean)
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt] if imod_episode==1 & episode!=4, by(q5_randcode) stats(mean)

*** emotions, averages by job search method ***
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m1==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m2==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m3==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m4==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m5==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m6==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m7==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m8==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m9==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m10==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m11==1 & episode==4
tabstat q5_happy_episode q5_sad_episode q5_stressed_episode [aw=emwgt2] if isel_mod==1 & sel_m12==1 & episode==4


*** emotions, fixed effect estimates ***
drop q5_randcode_7
eststo table7_happy: areg q5_happy_episode q5_randcode_* q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table7_sad: areg q5_sad_episode q5_randcode_* q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table7_stressed: areg q5_stressed_episode q5_randcode_* q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
drop sel_m1
eststo table7_happysel: areg sel_happy sel_m* q2_* [pw=emwgt2] if curwkwgt_tu!=. & imod_episode==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table7_sadsel: areg sel_sad sel_m* q2_* [pw=emwgt2] if curwkwgt_tu!=. & imod_episode==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table7_stressedsel: areg sel_stressed sel_m* q2_* [pw=emwgt2] if curwkwgt_tu!=. & imod_episode==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max



*** Table 8: emotions during random episodes of the day, by duration ***
eststo table8_happy_1: areg q5_happy_episode udur_wkpd_wrkacc  q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1 & episode< 4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table8_happy_2: areg q5_happy_episode udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8  q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1 & episode< 4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table8_sad_1: areg q5_sad_episode udur_wkpd_wrkacc  q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1 & episode< 4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table8_sad_2: areg q5_sad_episode udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8  q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1 & episode< 4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table8_stressed_1: areg q5_stressed_episode udur_wkpd_wrkacc  q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1 & episode< 4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table8_stressed_2: areg q5_stressed_episode udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8  q2_* [pw=emwgt] if curwkwgt_tu!=. & imod_episode==1 & episode< 4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max



*** Table 9: emotions during job search, by duration ***
eststo table9_happy_1: areg sel_happy udur_wkpd_wrkacc  q2_* [pw=emwgt] if curwkwgt_tu!=. & isel_mod==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table9_happy_2: areg sel_happy udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8  q2_* [pw=emwgt] if curwkwgt_tu!=. & isel_mod==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table9_sad_1: areg sel_sad udur_wkpd_wrkacc  q2_* [pw=emwgt] if curwkwgt_tu!=. & isel_mod==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table9_sad_2: areg sel_sad udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8  q2_* [pw=emwgt] if curwkwgt_tu!=. & isel_mod==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table9_stressed_1: areg sel_stressed udur_wkpd_wrkacc   q2_* [pw=emwgt] if curwkwgt_tu!=. & isel_mod==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table9_stressed_2: areg sel_stressed udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8  q2_* [pw=emwgt] if curwkwgt_tu!=. & isel_mod==1 & episode==4, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max




estout table5* using `njdir'brookings_table5.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table6* using `njdir'brookings_table6.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table7* using `njdir'brookings_table7.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table8* using `njdir'brookings_table8.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table9* using `njdir'brookings_table9.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

eststo clear

stop












